/**
   BasicHTTPClient.ino    Created on: 2024.05.4

   當Rx收到8051 Tx來的資料時，向指定網頁以GET方式發送資料
   許多與Arduino IDE溝通顯示的指令都註解掉了，
   因為程式燒錄進ESP-01後是插在8051板上，不需要這些訊息。

*/

#include <Arduino.h>

#include <ESP8266WiFi.h>
#include <ESP8266WiFiMulti.h>
#include <ESP8266HTTPClient.h>
#include <WiFiClient.h>

#define STASSID  "Your AP Name"     //你的無線分享器的名稱
#define STAPSK   "Your password"    //你的密碼

#define LEDpin  2  //ESP-01 builtin LED pin

ESP8266WiFiMulti WiFiMulti;
const char* ssid = STASSID;
const char* password = STAPSK;
String str1;
String str2;

void setup() {
  pinMode(LEDpin,OUTPUT);   //設定BUILDIN_LED(GPIO2)為OUTPUT
  digitalWrite(LEDpin,HIGH);   //HIGH是熄滅LED，LOW是點亮LED
  
  Serial.begin(9600);
  
  Serial.setTimeout(10);  //根據本案例感測模組送出一筆資料的耗費時間上限
  /*readString() 方法的行為是不論有無資料可讀取、也不論資料長度，
    都會等到 serial.setTimeout() 指定的工作時間截止後才返回。
    這段期間內讀取的資料全部放入字串 (String) 回傳。
    如果沒有資料，則字串長度為 0 。 */

  WiFi.mode(WIFI_STA);
  WiFiMulti.addAP(ssid, password);
}

void loop() {
  // wait for WiFi connection
  if ((WiFiMulti.run() == WL_CONNECTED)) {
    WiFiClient client;
    HTTPClient http;
    //Serial.println("WiFi Connected!");
   
    while(!Serial.available());   //Wait for 8051 send 溫度
    str1 = Serial.readString();
    str1.trim();
  
    while(!Serial.available());   //Wait for 8051 send 濕度
    str2 = Serial.readString();
    str2.trim();

    if (http.begin(client, "http://192.168.1.112/ESP8266_test.php?temp="+str1+"&humi="+str2)) {  // HTTP
      //Serial.print("[HTTP] GET...\n");
      //start connection and send HTTP header
      int httpCode = http.GET();

      // httpCode will be negative on error
      if (httpCode > 0) {
        // HTTP header has been send and Server response header has been handled
        //Serial.printf("[HTTP] GET... code: %d\n", httpCode);

        // file found at server
        //if (httpCode == HTTP_CODE_OK || httpCode == HTTP_CODE_MOVED_PERMANENTLY) {
        //  String payload = http.getString();
        //  Serial.println(payload);
       
        digitalWrite(LEDpin,LOW);  //BUILDIN_LED on 0.5Sec when get http page successful
        delay(100);
        digitalWrite(LEDpin,HIGH);
        //}
      } else {
      //  Serial.printf("[HTTP] GET... failed, error: %s\n", http.errorToString(httpCode).c_str());
      }
      http.end();
    } else {
      //Serial.printf("[HTTP} Unable to connect\n");
      digitalWrite(LEDpin,LOW);  
      delay(50);
      digitalWrite(LEDpin,HIGH);
      delay(50);
    }
  }
  delay(500);
}
